using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Drawing;
using System.Xml;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
    }

    protected void TextBox1_TextChanged(object sender, EventArgs e)
    {
        try
        {
            Panel1.BackColor = System.Drawing.Color.FromArgb(int.Parse(TextBox1.Text), int.Parse(TextBox2.Text), int.Parse(TextBox3.Text));
        }
        catch
        {
            TextBox1.Text = "Bd!";
            TextBox2.Text = "Bd!";
            TextBox3.Text = "Bd!";
        }
    }

    private string plikXML = "c:\\kolory.xml";
    
    protected void Button1_Click(object sender, EventArgs e)
    {
        XmlTextWriter xml=null;
	    try
	    {
		    //tworzenie pliku
		    xml=new XmlTextWriter(plikXML,System.Text.Encoding.UTF8);
		    xml.Formatting = Formatting.Indented;
		    xml.WriteStartDocument(true); //wersja XML itp.
		
		    xml.WriteComment("Kolory wybrane w aplikacji KoloryWebSite"); //komentarz

		    //<kolor>
		    xml.WriteStartElement("kolor");

		    //<stan uklad=RGB>
		    xml.WriteStartElement("stan");
		    xml.WriteAttributeString("uklad","RGB");			
			xml.WriteElementString("R",TextBox1.Text);
			xml.WriteElementString("G",TextBox2.Text);
			xml.WriteElementString("B",TextBox3.Text);
			xml.WriteEndElement();
			//</stan>

            //<stan uklad=RGB>
            xml.WriteStartElement("stan");
            xml.WriteAttributeString("uklad", "HSB");            
            Color kolor = Color.FromArgb(
                    int.Parse(TextBox1.Text), 
                    int.Parse(TextBox2.Text), 
                    int.Parse(TextBox3.Text));
            xml.WriteElementString("H", kolor.GetHue().ToString());
            xml.WriteElementString("S", kolor.GetSaturation().ToString());
            xml.WriteElementString("B", kolor.GetBrightness().ToString());
            xml.WriteEndElement();
            //</stan>

		    xml.WriteEndElement(); 
		    //</kolor>

		
		    xml.WriteEndDocument(); //koniec dokumentu
		    xml.Close();

            Label1.ForeColor = Color.Green;
            Label1.Text="Wybrany kolor zosta zapisany do pliku";
	    }
	    catch(Exception exc)
	    {
            Label1.ForeColor = Color.Red;
		    Label1.Text="Bd w zapisywaniu wybranego koloru ("+exc.Message+")";
		    xml.Close();
	    }
    }
    
    protected void Button2_Click(object sender, EventArgs e)
    {
        XmlTextReader xml = new XmlTextReader(plikXML);
        xml.ReadStartElement("kolor");

        xml.Read();
        string uklad = xml["uklad"];
        if (uklad == "RGB")
        {
            xml.ReadStartElement("stan");
            int r = int.Parse(xml.ReadElementString("R"));
            int g = int.Parse(xml.ReadElementString("G"));
            int b = int.Parse(xml.ReadElementString("B"));
            xml.ReadEndElement();

            //dalsza czesc pliku jest pomijana

            xml.Close();

            TextBox1.Text = r.ToString();
            TextBox2.Text = g.ToString();
            TextBox3.Text = b.ToString();
            TextBox1_TextChanged(sender, e);
        }
    }

    protected void Button3_Click(object sender, EventArgs e)
    {
        if (!System.IO.File.Exists(plikXML))
        {
            Label1.ForeColor = Color.Red;
            Label1.Text="Brak pliku " + plikXML + ".";
            return;
        }

        XmlReader xml = null;
        XmlReaderSettings ustawienia = new XmlReaderSettings();
        ustawienia.IgnoreWhitespace = true;
        ustawienia.IgnoreProcessingInstructions = true;

        string s = "";

        try
        {
            xml = XmlReader.Create(plikXML, ustawienia);

            while (xml.Read())
            {
                s += "(" + xml.Depth + ")\t";
                switch (xml.NodeType)
                {
                    case XmlNodeType.XmlDeclaration: s += "Deklaracja: " + xml.Value; break;
                    case XmlNodeType.Comment: s += "Komentarz: " + xml.Value; break;
                    //case XmlNodeType.Element: s += "Element: " + xml.Name; break;
                    case XmlNodeType.Element:
                        s += "Element: " + xml.Name;
                        if (xml.HasAttributes)
                        {
                            s += ", atrybuty: ";
                            for (int i = 0; i < xml.AttributeCount; i++)
                            {
                                xml.MoveToAttribute(i);
                                s += xml.Name + "=" + xml.QuoteChar + xml.Value + xml.QuoteChar + " ";
                            }
                        }
                        break;
                    case XmlNodeType.EndElement: s += "Zakoczenie elementu: " + xml.Name; break;
                    case XmlNodeType.Text: s += "Tekst: " + xml.Value; break;
                }
                s += "\n";
            }
        }
        catch (Exception exc)
        {
            Label1.ForeColor = Color.Red;
            Label1.Text="Bd podczas czytania danych z pliku (" + exc.Message + ")";
        }
        finally
        {
            xml.Close();
        }

        Label1.ForeColor = Color.Black;
        Label1.Text = "Rezultat analizy pliku " + plikXML + " umieszczony zosta w polu tekstowym";
        TextBox4.Text=s;            
    }
}
